#!/bin/bash
# ===========================================================================
#    Automated script generated by the CSB server for Arctic3D execution
# ===========================================================================
# September 29, 2023 13:57:26 UTC
# ===========================================================================
# ===========================================================================
outputfile="output.out"

echo "# ===========================================================================" &>> $outputfile
log="arctic3d.log"

cmd="arctic3d --full P01584"












cmd+=" --threshold 0.866"



cmd+=" --linkage_strategy average"





cmd+=" --int_cov_cutoff 0.7"


echo "command: $cmd" &>> $outputfile
$cmd &> $log

status=$?
echo "exit status: $status" &>> $outputfile
echo "log:" &>> $outputfile
cat $log >> $outputfile

if [ $status -eq 255 ]; then
  #  This is a special case where the program is not able to find any
  #  interface for the given protein. In this case, we just exit with
  #  status 0 and do not run the localisation step.
  echo "No interfaces found, exiting with status 0"
  exit 0
fi







mv arctic3d-P01584/* . > /dev/null 2>&1

exit $status
# ===========================================================================